/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.sysinfo;

import com.ibm.hwmca.base.sysinfo.SysInfoConstants;
import com.ibm.hwmca.base.sysinfo.SysInfoEcData;
import com.ibm.hwmca.base.sysinfo.SysInfoEcInternalCodeData;
import com.ibm.hwmca.base.sysinfo.SysInfoErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.sysinfo.SysInfoData;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SysInfoEcDetailsBean
extends PanelBean
implements SysInfoErrorIds,
SysInfoConstants {
    private String m_sPartNumberOutput;
    private String m_sChangeNumberOutput;
    private String m_sChangeTypeOutput;
    private String m_sChangeDescriptionOutput;
    private String m_sRetrieveLevelOutput;
    private String m_sRetrieveDateOutput;
    private String m_sRetrieveTimeOutput;
    private String m_sInstallLevelOutput;
    private String m_sInstallDateOutput;
    private String m_sInstallTimeOutput;
    private String m_sActivateLevelOutput;
    private String m_sActivateDateOutput;
    private String m_sActivateTimeOutput;
    private String m_sAcceptLevelOutput;
    private String m_sAcceptDateOutput;
    private String m_sAcceptTimeOutput;
    private String m_sRemoveLevelOutput;
    private String m_sRemoveDateOutput;
    private String m_sRemoveTimeOutput;
    private String action;
    private SysInfoEcInternalCodeData ecInternalCodeData;
    private LocalizableText displayableName;
    private Locale locale;
    private static final String TRACE_MASKT = "HSYIEDBT";
    private static final String TRACE_MASKF = "HSYIEDBF";
    private static final String TRACE_MASKD = "HSYIEDBD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-53, "SysInfoEcDetailsBean");

    public SysInfoEcDetailsBean(LocalizableText displayableName, SysInfoData sysEcInfoData) {
        try {
            this.locale = ClientUserContext.staticGetLocale();
        }
        catch (Exception e) {
            this.locale = Locale.getDefault();
        }
        this.displayableName = displayableName;
        this.ecInternalCodeData = (SysInfoEcInternalCodeData)sysEcInfoData;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKF, "SysInfoEcDetailsBean.prepare()-->");
        this.setSysInfoDetails();
        Trace.trace(TRACE_MASKF, "<-- SysInfoEcDetailsBean.prepare()");
    }

    public void load() {
        Trace.trace(TRACE_MASKF, "--> SysInfoEcDetailsBean.load()");
        this.m_sPartNumberOutput = "";
        this.m_sChangeNumberOutput = "";
        this.m_sChangeTypeOutput = "";
        this.m_sChangeDescriptionOutput = "";
        this.m_sRetrieveLevelOutput = "";
        this.m_sRetrieveDateOutput = "";
        this.m_sRetrieveTimeOutput = "";
        this.m_sInstallLevelOutput = "";
        this.m_sInstallDateOutput = "";
        this.m_sInstallTimeOutput = "";
        this.m_sActivateLevelOutput = "";
        this.m_sActivateDateOutput = "";
        this.m_sActivateTimeOutput = "";
        this.m_sAcceptLevelOutput = "";
        this.m_sAcceptDateOutput = "";
        this.m_sAcceptTimeOutput = "";
        this.m_sRemoveLevelOutput = "";
        this.m_sRemoveDateOutput = "";
        this.m_sRemoveTimeOutput = "";
        Trace.trace(TRACE_MASKF, "<-- SysInfoEcDetailsBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "<- SysInfoEcDetailsBean.panelAction()" + command);
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            if (command.endsWith("OkButton")) {
                Trace.trace(TRACE_MASKF, "OK  pressed - dispose of modal panel");
            } else {
                Trace.trace(TRACE_MASKT, "other action detected - dispose of modal panel");
            }
            request.setData("event", event);
            request.setData("panel", "CodeChangeDetailsPanel");
            request.setDisposed();
            this.postTaskletRequest(request);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(logInfo, 48, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoEcDetailsBean.panelAction()");
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    private void setSysInfoDetails() {
        Trace.trace(TRACE_MASKT, "-> SysInfoEcDetailsBean.setSysInfoDetails()");
        SysInfoEcData ecData = this.ecInternalCodeData.getSysInfoEcData(0);
        try {
            String timeString;
            String dateString;
            this.ecInternalCodeData.dumpSysInfoEcData(0);
            Trace.trace(TRACE_MASKD, "calling setPartNumberOutput ecData.getPartNumber = " + ecData.getEcPartNumber());
            this.setPartNumberOutput(ecData.getEcPartNumber());
            Trace.trace(TRACE_MASKD, "calling setChangeNumberOutput ecData.getPartNumber = " + ecData.getEcNumber());
            this.setChangeNumberOutput(ecData.getEcNumber());
            Trace.trace(TRACE_MASKD, "calling setChangeTypeOutput ecData.getEcType = " + ecData.getEcType().toString());
            this.setChangeTypeOutput(ecData.getEcType().toString());
            Trace.trace(TRACE_MASKD, "calling setChangeDescOutput ecData.getEcDesc = " + ecData.getEcDescription().toString());
            this.setChangeDescriptionOutput(ecData.getEcDescription().toString());
            Trace.trace(TRACE_MASKD, "calling setRetrieveLevel level = " + ecData.getRetrieveMclData().getLevel());
            this.setRetrieveLevelOutput(ecData.getRetrieveMclData().getLevel());
            Date dateTime = ecData.getRetrieveMclData().getDateTime();
            if (dateTime != null && dateTime.getTime() != 0L) {
                dateString = this.getFormattedDate(dateTime);
                timeString = this.getFormattedTime(dateTime);
            } else {
                dateString = " ";
                timeString = " ";
            }
            Trace.trace(TRACE_MASKD, "calling setRetrieveDate dateString = " + dateString);
            this.setRetrieveDateOutput(dateString);
            Trace.trace(TRACE_MASKD, "calling setRetrieveTime timeString = " + timeString);
            this.setRetrieveTimeOutput(timeString);
            Trace.trace(TRACE_MASKD, "calling setInstallLevel level = " + ecData.getInstallMclData().getLevel());
            this.setInstallLevelOutput(ecData.getInstallMclData().getLevel());
            dateTime = ecData.getInstallMclData().getDateTime();
            if (dateTime != null && dateTime.getTime() != 0L) {
                dateString = this.getFormattedDate(dateTime);
                timeString = this.getFormattedTime(dateTime);
            } else {
                dateString = " ";
                timeString = " ";
            }
            Trace.trace(TRACE_MASKD, "calling setInstallDate dateString = " + dateString);
            this.setInstallDateOutput(dateString);
            Trace.trace(TRACE_MASKD, "calling setInstallTime timeString = " + timeString);
            this.setInstallTimeOutput(timeString);
            Trace.trace(TRACE_MASKD, "calling setActivateLevel level = " + ecData.getActivatedMclData().getLevel());
            this.setActivateLevelOutput(ecData.getActivatedMclData().getLevel());
            dateTime = ecData.getActivatedMclData().getDateTime();
            if (dateTime != null && dateTime.getTime() != 0L) {
                dateString = this.getFormattedDate(dateTime);
                timeString = this.getFormattedTime(dateTime);
            } else {
                dateString = " ";
                timeString = " ";
            }
            Trace.trace(TRACE_MASKD, "calling setActivateDate dateString = " + dateString);
            this.setActivateDateOutput(dateString);
            Trace.trace(TRACE_MASKD, "calling setActivateTime timeString = " + timeString);
            this.setActivateTimeOutput(timeString);
            Trace.trace(TRACE_MASKD, "calling setAcceptLevel level = " + ecData.getAcceptedMclData().getLevel());
            this.setAcceptLevelOutput(ecData.getAcceptedMclData().getLevel());
            dateTime = ecData.getAcceptedMclData().getDateTime();
            if (dateTime != null && dateTime.getTime() != 0L) {
                dateString = this.getFormattedDate(dateTime);
                timeString = this.getFormattedTime(dateTime);
            } else {
                dateString = " ";
                timeString = " ";
            }
            Trace.trace(TRACE_MASKD, "calling setAcceptDate dateString = " + dateString);
            this.setAcceptDateOutput(dateString);
            Trace.trace(TRACE_MASKD, "calling setAcceptTime timeString = " + timeString);
            this.setAcceptTimeOutput(timeString);
            Trace.trace(TRACE_MASKD, "calling setRemoveLevel level = " + ecData.getRemoveMclData().getLevel());
            this.setRemoveLevelOutput(ecData.getRemoveMclData().getLevel());
            dateTime = ecData.getRemoveMclData().getDateTime();
            if (dateTime != null && dateTime.getTime() != 0L) {
                dateString = this.getFormattedDate(dateTime);
                timeString = this.getFormattedTime(dateTime);
            } else {
                dateString = " ";
                timeString = " ";
            }
            Trace.trace(TRACE_MASKD, "calling setRemoveDate dateString = " + dateString);
            this.setRemoveDateOutput(dateString);
            Trace.trace(TRACE_MASKD, "calling setRemoveTime timeString = " + timeString);
            this.setRemoveTimeOutput(timeString);
        }
        catch (IllegalUserDataException iude) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<- SysInfoEcDetailsBean.setSysInfoDetails()");
    }

    public String getFormattedDate(Date date) {
        Calendar calDate;
        Trace.trace(TRACE_MASKT, "--> SysInfoEcDetailsBean.getFormattedDate(Date)");
        String dateString = "";
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            calDate = Calendar.getInstance(userContext.getTimeZone(), this.locale);
        }
        catch (NullContextException e) {
            calDate = Calendar.getInstance(this.locale);
        }
        calDate.setTime(date);
        Trace.trace(TRACE_MASKD, "Calendar after setTime = " + calDate);
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy", this.locale);
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            formatter.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKD, "formatter = " + formatter);
        dateString = formatter.format(calDate.getTime());
        Trace.trace(TRACE_MASKD, "dateString after formatting = " + dateString);
        Trace.trace(TRACE_MASKT, "<-- SysInfoEcDetailsBean.getFormattedDate(Date)");
        return dateString;
    }

    public String getFormattedTime(Date date) {
        Calendar calTime;
        Trace.trace(TRACE_MASKT, "-->SysInfoEcDetailsBean.getFormattedTime(Date)");
        String timeString = "";
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            calTime = Calendar.getInstance(userContext.getTimeZone(), this.locale);
        }
        catch (NullContextException e) {
            calTime = Calendar.getInstance(this.locale);
        }
        calTime.setTime(date);
        Trace.trace(TRACE_MASKD, "Calendar after setTime = " + calTime);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss zz", this.locale);
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            formatter.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKD, "formatter = " + formatter);
        timeString = formatter.format(calTime.getTime());
        Trace.trace(TRACE_MASKD, "timeString after formatting = " + timeString);
        Trace.trace(TRACE_MASKT, "<-- SysInfoEcDetailsBean.getFormattedTime(Date)");
        return timeString;
    }

    public String getPartNumberOutput() {
        return this.m_sPartNumberOutput;
    }

    public void setPartNumberOutput(String s) throws IllegalUserDataException {
        this.m_sPartNumberOutput = s;
    }

    public String getChangeNumberOutput() {
        return this.m_sChangeNumberOutput;
    }

    public void setChangeNumberOutput(String s) throws IllegalUserDataException {
        this.m_sChangeNumberOutput = s;
    }

    public String getChangeTypeOutput() {
        return this.m_sChangeTypeOutput;
    }

    public void setChangeTypeOutput(String s) throws IllegalUserDataException {
        this.m_sChangeTypeOutput = s;
    }

    public String getChangeDescriptionOutput() {
        return this.m_sChangeDescriptionOutput;
    }

    public void setChangeDescriptionOutput(String s) throws IllegalUserDataException {
        this.m_sChangeDescriptionOutput = s;
    }

    public String getRetrieveLevelOutput() {
        return this.m_sRetrieveLevelOutput;
    }

    public void setRetrieveLevelOutput(String s) throws IllegalUserDataException {
        this.m_sRetrieveLevelOutput = s;
    }

    public String getRetrieveDateOutput() {
        return this.m_sRetrieveDateOutput;
    }

    public void setRetrieveDateOutput(String s) throws IllegalUserDataException {
        this.m_sRetrieveDateOutput = s;
    }

    public String getRetrieveTimeOutput() {
        return this.m_sRetrieveTimeOutput;
    }

    public void setRetrieveTimeOutput(String s) throws IllegalUserDataException {
        this.m_sRetrieveTimeOutput = s;
    }

    public String getInstallLevelOutput() {
        return this.m_sInstallLevelOutput;
    }

    public void setInstallLevelOutput(String s) throws IllegalUserDataException {
        this.m_sInstallLevelOutput = s;
    }

    public String getInstallDateOutput() {
        return this.m_sInstallDateOutput;
    }

    public void setInstallDateOutput(String s) throws IllegalUserDataException {
        this.m_sInstallDateOutput = s;
    }

    public String getInstallTimeOutput() {
        return this.m_sInstallTimeOutput;
    }

    public void setInstallTimeOutput(String s) throws IllegalUserDataException {
        this.m_sInstallTimeOutput = s;
    }

    public String getActivateLevelOutput() {
        return this.m_sActivateLevelOutput;
    }

    public void setActivateLevelOutput(String s) throws IllegalUserDataException {
        this.m_sActivateLevelOutput = s;
    }

    public String getActivateDateOutput() {
        return this.m_sActivateDateOutput;
    }

    public void setActivateDateOutput(String s) throws IllegalUserDataException {
        this.m_sActivateDateOutput = s;
    }

    public String getActivateTimeOutput() {
        return this.m_sActivateTimeOutput;
    }

    public void setActivateTimeOutput(String s) throws IllegalUserDataException {
        this.m_sActivateTimeOutput = s;
    }

    public String getAcceptLevelOutput() {
        return this.m_sAcceptLevelOutput;
    }

    public void setAcceptLevelOutput(String s) throws IllegalUserDataException {
        this.m_sAcceptLevelOutput = s;
    }

    public String getAcceptDateOutput() {
        return this.m_sAcceptDateOutput;
    }

    public void setAcceptDateOutput(String s) throws IllegalUserDataException {
        this.m_sAcceptDateOutput = s;
    }

    public String getAcceptTimeOutput() {
        return this.m_sAcceptTimeOutput;
    }

    public void setAcceptTimeOutput(String s) throws IllegalUserDataException {
        this.m_sAcceptTimeOutput = s;
    }

    public String getRemoveLevelOutput() {
        return this.m_sRemoveLevelOutput;
    }

    public void setRemoveLevelOutput(String s) throws IllegalUserDataException {
        this.m_sRemoveLevelOutput = s;
    }

    public String getRemoveDateOutput() {
        return this.m_sRemoveDateOutput;
    }

    public void setRemoveDateOutput(String s) throws IllegalUserDataException {
        this.m_sRemoveDateOutput = s;
    }

    public String getRemoveTimeOutput() {
        return this.m_sRemoveTimeOutput;
    }

    public void setRemoveTimeOutput(String s) throws IllegalUserDataException {
        this.m_sRemoveTimeOutput = s;
    }
}

